DROP PROCEDURE [hips].[CodeSystemGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon
-- Create date: 15 Oct 2012
-- Description:   Gets a specific record from the Country Table
-- =============================================
CREATE PROCEDURE [hips].[CodeSystemGet] 
(
	@CodeSystemId INT = null
	,@DateModified DATETIME = null
)
AS
BEGIN
SELECT  c.CodeSystemId,
		c.Code,
		c.Description,
		c.Oid,
		c.Version,
		c.DateCreated,
		c.UserCreated,
		c.DateModified,
		c.UserModified
		
FROM  hips.CodeSystem c
WHERE (c.CodeSystemId = @CodeSystemId OR @CodeSystemId IS NULL)
AND (c.DateModified < @DateModified OR @DateModified IS NULL)
ORDER BY c.Description asc
END
GO

